/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCellRenderer;
import filenet.vw.apps.taskman.VWTaskContentEvent;
import filenet.vw.apps.taskman.VWTaskContentListener;
import filenet.vw.apps.taskman.VWTaskContextMenu;
import filenet.vw.apps.taskman.VWTaskDefaultTableModel;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWTaskTablePanel
extends JPanel
implements ListSelectionListener,
IVWMouseActionListener,
TableModelListener {
    private VWTable m_table = null;
    private VWTaskDefaultTableModel m_tableModel = null;
    private VWTaskContentListener m_contentListener = null;
    private JScrollPane m_scrollPane = null;
    private ActionListener m_actionListener = null;

    public VWTaskTablePanel(VWTable table, VWTaskDefaultTableModel tableModel, String title) {
        this.init(table, tableModel, title);
    }

    public VWTaskTablePanel(VWTaskDefaultTableModel tableModel, String title) {
        VWTable table = new VWTable();
        table.setShowGrid(false);
        table.setDefaultRenderer(Icon.class, new VWTaskCellRenderer());
        table.setDefaultRenderer(String.class, new VWTaskCellRenderer());
        table.setDefaultRenderer(ImageIcon.class, new VWTaskCellRenderer());
        table.setDefaultRenderer(Integer.class, new VWTaskCellRenderer());
        table.setDefaultRenderer(VWTaskBaseNode.class, new VWTaskCellRenderer());
        this.init(table, tableModel, title);
        this.resizeColumns(table);
    }

    public VWTaskTablePanel(VWTable table, VWTaskDefaultTableModel tableModel) {
        this(table, tableModel, null);
    }

    public VWTaskTablePanel(VWTaskDefaultTableModel tableModel) {
        this(tableModel, null);
    }

    public void refresh() {
        this.m_tableModel.refresh();
    }

    public VWTable getTable() {
        return this.m_table;
    }

    public void addBottomPanel(JPanel panel) {
        this.add((Component)panel, "Last");
    }

    public void clearSelection() {
        this.m_table.clearSelection();
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (this.m_table == null) {
                return;
            }
            VWTaskBaseNode node = this.m_tableModel.getNodeAt(this.m_table.getSelectedRow());
            if (node != null && this.m_contentListener != null) {
                this.m_contentListener.taskContentChanged(new VWTaskContentEvent(this, node, 2));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        Point pt = null;
        int rowIndex = -1;
        int columnIndex = -1;
        Object tableModel = null;
        try {
            if (this.m_table == null) {
                return;
            }
            pt = event.getPoint();
            rowIndex = this.m_table.rowAtPoint(pt);
            columnIndex = this.m_table.columnAtPoint(pt);
            if (rowIndex == -1 || columnIndex == -1) {
                return;
            }
            VWTaskBaseNode node = this.m_tableModel.getNodeAt(this.m_table.getSelectedRow());
            this.m_contentListener.taskContentChanged(new VWTaskContentEvent(this, node, 1));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createPopup(MouseEvent event) {
        VWTaskBaseNode node;
        if (this.m_table == null || this.m_tableModel == null) {
            return;
        }
        Point pt = event.getPoint();
        int row = this.m_table.rowAtPoint(pt);
        if (row == -1) {
            return;
        }
        if (!this.m_table.isRowSelected(row)) {
            this.m_table.setRowSelectionInterval(row, row);
        }
        if ((node = this.m_tableModel.getNodeAt(row)) != null) {
            VWTaskContextMenu contextMenu = new VWTaskContextMenu(node, this.m_actionListener);
            contextMenu.show(this.m_table, pt.x, pt.y);
        }
    }

    public void tableChanged(TableModelEvent event) {
    }

    protected void setContentListener(VWTaskContentListener listener) {
        this.m_contentListener = listener;
    }

    protected void setActionListener(ActionListener listener) {
        this.m_actionListener = listener;
    }

    private void init(VWTable table, VWTaskDefaultTableModel tableModel, String title) {
        try {
            this.setLayout(new BorderLayout());
            this.m_tableModel = tableModel;
            this.m_table = table;
            this.m_table.getSelectionModel().setSelectionMode(0);
            this.m_table.getSelectionModel().addListSelectionListener(this);
            this.m_table.addMouseListener(new VWMouseAdapter(this));
            this.m_table.setModel(this.m_tableModel);
            this.m_tableModel.addTableModelListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_table, this, VWResource.TableOfComponentMananagerNode, VWResource.TableOfComponentMananagerNode);
            VWAccessibilityHelper.setAccessibility(this.m_table.getTableHeader(), this, VWResource.TableOfComponentMananagerNode, VWResource.TableOfComponentMananagerNode);
            this.m_table.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (VWTaskTablePanel.this.m_tableModel.getRowCount() == 0) {
                        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            });
            if (title != null) {
                VWToolbarBorder borderPanel = new VWToolbarBorder(title);
                JPanel panel = borderPanel.getClientPanel();
                panel.setLayout(new BorderLayout());
                this.m_scrollPane = new JScrollPane(this.m_table);
                panel.add((Component)this.m_scrollPane, "Center");
                this.add((Component)borderPanel, "Center");
            } else {
                this.add((Component)new JScrollPane(this.m_table), "Center");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void resizeColumns(VWTable table) {
    }
}

